Unit ConeClass;

Interface

Uses StrUtils, SysUtils;

Type
  Tcone = Class
  Private
    diameter: Double;
    height: Double;
    Function radius: Double;

  Public
    Constructor Create; Overload;
    Constructor Create(height, diameter: Double); Overload;
    Function getDiameter: Double;
    Function getHeight: Double;
    Procedure setDiameter(diameter: Double);
    Procedure setHeight(height: Double);
    Function slantHeight: Double;
    Function volume: Double;
    Function surfaceArea: Double;
    Function toString: String;

  End;

Implementation

{ Tcone
  r = radius
  h = height
  s = slant height
  V = volume
  L = lateral surface area
  B = base surface area
  A = total surface area
}
{ There are two possible implementations of conic calculations

  1. trigonometry, as exemplified by:
  http://mathcentral.uregina.ca/QQ/database/QQ.09.07/s/marija1.html

  2. Pythagorus, as exemplified by:
  https://mathbitsnotebook.com/Geometry/3DShapes/3DCones.html

  Of course its better to work these things out from first principles
  rather than applying formulas without understanding their derivation.

  Delphi constant in System unit: sLineBreak = AnsiString(#13#10);
  Interesting fact: Line ending in Linux #10, AppleOS, #13, Windows #13#10
  Embacadero: It is preferable to use this constabnt
  rather than hard code #13#10 or #10 to move to a new line in a text output.
  }

Function Tcone.radius: Double;
Begin
  result := diameter / 2;
End;

Constructor Tcone.Create;
Begin
  { Default: no code implemented here. }
End;

Constructor Tcone.Create(height, diameter: Double);
Begin
  self.height := height;
  self.diameter := diameter;
End;

Function Tcone.getDiameter: Double;
Begin
  result := self.diameter;
End;

Function Tcone.getHeight: Double;
Begin
  result := self.height;
End;

Procedure Tcone.setDiameter(diameter: Double);
Begin
  self.diameter := diameter
End;

Procedure Tcone.setHeight(height: Double);
Begin
  self.height := height
End;

Function Tcone.slantHeight: Double;
Begin
  result := Sqrt((radius * radius) + (height * height));
End;

Function Tcone.surfaceArea: Double;

Begin
  { Surface area: pi*r(r + s) }
  result := Pi * radius * (radius + slantHeight);
End;

Function Tcone.toString: String;
Begin
  result := format('Height: %f%sDiameter of Base: %f', [height, slineBreak,
    diameter]);
End;

Function Tcone.volume: Double;
Var
  areaBase: Double;
Begin
  areaBase := Pi * radius * radius;
  result := 1 / 3 * (areaBase * height)
End;

End.
